/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.base;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.client.keybinds.ModKeyBindings;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.items.base.AccessoryBase;
import xzeroair.trinkets.races.EntityRace;
import xzeroair.trinkets.races.IRaceProvider;
import xzeroair.trinkets.races.dwarf.config.DwarfConfig;
import xzeroair.trinkets.races.elf.config.ElfConfig;
import xzeroair.trinkets.races.fairy.config.FairyConfig;
import xzeroair.trinkets.races.titan.config.TitanConfig;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.trinkets.shared.TransformationRingConfig;
import xzeroair.trinkets.util.helpers.TranslationHelper;

public class TrinketRaceBase
extends AccessoryBase
implements IRaceProvider {
    public TransformationRingConfig serverConfig;
    protected EntityRace race;

    public TrinketRaceBase(String name, EntityRace race, TransformationRingConfig config) {
        super(name);
        this.race = race;
        this.setUUID("892cfd1f-25c5-44a0-9154-f3b630538c82");
        this.serverConfig = config;
    }

    @Override
    public String[] getAttributeConfig() {
        return this.race.getRaceAttributes().getAttributes();
    }

    @Override
    public void initAbilities(ItemStack stack, EntityLivingBase entity, List<IAbilityInterface> abilities) {
    }

    @Override
    protected void initAttributes(String[] attributeConfig, EntityLivingBase entity) {
    }

    @Override
    protected String customItemInformation(ItemStack stack, World world, ITooltipFlag flagIn, int index, String translation) {
        TranslationHelper helper = TranslationHelper.INSTANCE;
        EntityRace r = this.getRace();
        if (r != null) {
            TranslationHelper.OptionEntry size = new TranslationHelper.OptionEntry("rsize", r.getRaceHeight() + "%");
            if (r.equals(EntityRaces.fairy)) {
                FairyConfig config = TrinketsConfig.SERVER.races.fairy;
                TranslationHelper.LangEntry key1 = new TranslationHelper.LangEntry(this.func_77667_c(stack), "creativeflight", config.creative_flight);
                return helper.formatAddVariables(translation, size, key1);
            }
            if (r.equals(EntityRaces.dwarf)) {
                DwarfConfig config = TrinketsConfig.SERVER.races.dwarf;
                TranslationHelper.LangEntry key1 = new TranslationHelper.LangEntry(this.func_77667_c(stack), "fortune", config.fortune);
                TranslationHelper.LangEntry key2 = new TranslationHelper.LangEntry(this.func_77667_c(stack), "skilledminer", config.skilled_miner);
                TranslationHelper.LangEntry key3 = new TranslationHelper.LangEntry(this.func_77667_c(stack), "staticminer", config.static_mining);
                return helper.formatAddVariables(translation, size, key1, key2, key3);
            }
            if (r.equals(EntityRaces.elf)) {
                ElfConfig config = TrinketsConfig.SERVER.races.elf;
                TranslationHelper.LangEntry key1 = new TranslationHelper.LangEntry(this.func_77667_c(stack), "chargeshot", config.charge_shot);
                return helper.formatAddVariables(translation, size, key1);
            }
            if (r.equals(EntityRaces.dragon)) {
                TranslationHelper.KeyBindEntry key1 = new TranslationHelper.KeyBindEntry("denvkb", ModKeyBindings.DRAGONS_EYE_ABILITY.getDisplayName());
                TranslationHelper.KeyBindEntry key2 = new TranslationHelper.KeyBindEntry("breathkb", ModKeyBindings.RACE_ABILITY.getDisplayName());
                return helper.formatAddVariables(translation, size, key1, key2);
            }
            if (r.equals(EntityRaces.titan)) {
                TitanConfig config = TrinketsConfig.SERVER.races.titan;
                TranslationHelper.LangEntry key1 = new TranslationHelper.LangEntry(this.func_77667_c(stack), "heavy", config.sink);
                return helper.formatAddVariables(translation, size, key1);
            }
            return helper.formatAddVariables(translation, size);
        }
        return helper.formatAddVariables(translation, new TranslationHelper.KeyEntry[0]);
    }

    @Override
    public EntityRace getRace() {
        return this.race;
    }

    @Override
    public boolean ItemEnabled() {
        return this.serverConfig.enabled;
    }

    @Override
    public void registerModels() {
        Trinkets.proxy.registerItemRenderer(this, 0, "inventory");
    }
}

